<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Exchange extends Model 
{

    protected $table = 'exchanges';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'box_id', 'customer_id', 'exchange_agency_id', 'cashout_agency_id', 'exchange_fee_id', 'country_withdrawal_id', 'amount', 'currency', 'sending_code', 'slug', 'receipt_code', 'exchange_fee_amount', 'local_withdrawal', 'withdrawal_date', 'motif', 'autre_motif', 'sell', 'status');
    protected $visible = array('user_id', 'box_id', 'customer_id', 'exchange_agency_id', 'cashout_agency_id', 'exchange_fee_id', 'country_withdrawal_id', 'amount', 'currency', 'sending_code', 'slug', 'receipt_code', 'exchange_fee_amount', 'local_withdrawal', 'withdrawal_date', 'motif', 'autre_motif', 'sell', 'status');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function customer()
    {
        return $this->belongsTo('App\Models\Customer', 'customer_id');
    }

    public function exchangeAgency()
    {
        return $this->belongsTo('App\Models\Agency', 'exchange_agency_id');
    }

    public function exchangeFee()
    {
        return $this->belongsTo('App\Models\ExchangeFee', 'exchange_fee_id');
    }

    public function box()
    {
        return $this->belongsTo('App\Models\Box', 'box_id');
    }

    public function country()
    {
        return $this->belongsTo('App\Models\Country', 'country_withdrawal_id');
    }

    public function cashoutAgency()
    {
        return $this->hasMany('App\Models\Agency', 'cashout_agency_id');
    }

}